Jump = class()

function Jump:created(force)
    -- you can accept and set parameters here
    self.force = force
    self.hasJumped = false;
    self.manager = scene.main:findEntity("Manager"):get(GameManager)
    gameWorld.physics2d.gravity = vec2(0,0)
end

function Jump:update()
    if not self.hasJumped or not self.manager.startGame then
        scene.main.physics2d.gravity = vec2(0,0)
        self.entity.body2d.linearVelocity = vec2(0,0)
    elseif not self.manager.currentRestarting then
        scene.main.physics2d.gravity = vec2(0,-33)
    end
    
    if self.manager.isRestarting then
        scene.main.physics2d.gravity = vec2(0,0)
        self.entity.body2d.linearVelocity = vec2(0,0)
    end
end

function Jump:touched(touch)
    
    if(self.manager.canStart) then
        self.entity:get(Bird).shouldReset = false
        self.manager:restart()
        self.manager.canStart = false
    end
    
    if touch.state == BEGAN and not self.manager.gameOver then
        local instance = sound.play(asset.sfx_wing)
        table.insert(allSounds, instance)
        self.manager.startGame = true
        self.hasJumped = true
        self.entity.body2d.linearVelocity = vec2(0,0)
        self.entity.body2d:applyForce(vec2(0, self.force))
    end
    
end
